function [d]=indirect_inference_OU_crude_no_noise(par,coeffs,W);

% Purpose: Compute the criterion function as the squared difference between mean(beta_S) and beta_hat for the OU
% model without noise

% input: par: structural parameters (3x1) vector
%        coeffs: auxiliary estimates (3x1) vector (last element of beta is
%        neglected)
%       W : matrix of innovations (Tx2xH)


H=size(W,3);

beta=zeros(3,H);  % preallocate beta_S

% retransform the structural coefficients (they have to be non-negative)
mu=exp(par(1));

sigma=exp(par(2));

kappa=exp(par(3));

params=[mu,sigma,kappa];

for j=1:H;
    
    w=W(:,:,j); % select the j-element on the third dimension of W
    
    [y]=simulate_OU_exact(params,w(:,1)); % simulate OU exactly (we do not add the noise)

    [beta_hat]=crude_discretrization_OLS(y);  % estimate the AR(1) model with intercept
    
    beta(:,j) = [beta_hat(1:3)];  % retain the first three elements of beta
    
end;
 beta_star=mean(beta')'-coeffs; % compute the difference mean(beta_S)-beta_hat
 
 d=beta_star'*beta_star; % sum of the squared differences (no weigthing requied as p=q)
